/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.platform.yui.compressor;

import com.yahoo.platform.yui.compressor.JavaScriptIdentifier;
import com.yahoo.platform.yui.compressor.JavaScriptToken;
import com.yahoo.platform.yui.compressor.ScriptOrFnScope;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptRuntime;

public class JavaScriptCompressor {
    static final ArrayList ones;
    static final ArrayList twos;
    static final ArrayList threes;
    static final Set builtin;
    static final Map literals;
    static final Set reserved;
    private static final Pattern SIMPLE_IDENTIFIER_NAME_PATTERN;
    private ErrorReporter logger;
    private boolean munge;
    private boolean verbose;
    private static final int BUILDING_SYMBOL_TREE = 1;
    private static final int CHECKING_SYMBOL_TREE = 2;
    private int mode;
    private int offset;
    private int braceNesting;
    private ArrayList tokens;
    private Stack scopes = new Stack();
    private ScriptOrFnScope globalScope = new ScriptOrFnScope(-1, null);
    private Hashtable indexedScopes = new Hashtable();

    private static int countChar(String haystack, char needle) {
        int idx = 0;
        int count = 0;
        int length = haystack.length();
        while (idx < length) {
            char c;
            if ((c = haystack.charAt(idx++)) != needle) continue;
            ++count;
        }
        return count;
    }

    private static int printSourceString(String source, int offset, StringBuffer sb) {
        int length = source.charAt(offset);
        ++offset;
        if ((0x8000 & length) != 0) {
            length = (Short.MAX_VALUE & length) << 16 | source.charAt(offset);
            ++offset;
        }
        if (sb != null) {
            String str = source.substring(offset, offset + length);
            sb.append(str);
        }
        return offset + length;
    }

    private static int printSourceNumber(String source, int offset, StringBuffer sb) {
        double number = 0.0;
        char type = source.charAt(offset);
        ++offset;
        if (type == 'S') {
            if (sb != null) {
                number = source.charAt(offset);
            }
            ++offset;
        } else if (type == 'J' || type == 'D') {
            if (sb != null) {
                long lbits = (long)source.charAt(offset) << 48;
                lbits |= (long)source.charAt(offset + 1) << 32;
                lbits |= (long)source.charAt(offset + 2) << 16;
                number = type == 'J' ? (double)lbits : Double.longBitsToDouble(lbits |= (long)source.charAt(offset + 3));
            }
            offset += 4;
        } else {
            throw new RuntimeException();
        }
        if (sb != null) {
            sb.append(ScriptRuntime.numberToString(number, 10));
        }
        return offset;
    }

    private static ArrayList parse(Reader in, ErrorReporter reporter) throws IOException, EvaluatorException {
        CompilerEnvirons env = new CompilerEnvirons();
        env.setLanguageVersion(170);
        Parser parser = new Parser(env, reporter);
        parser.parse(in, null, 1);
        String source = parser.getEncodedSource();
        int offset = 0;
        int length = source.length();
        ArrayList<JavaScriptToken> tokens = new ArrayList<JavaScriptToken>();
        StringBuffer sb = new StringBuffer();
        block4: while (offset < length) {
            char tt = source.charAt(offset++);
            switch (tt) {
                case '\'': 
                case ')': 
                case '0': 
                case '\u00a0': 
                case '\u00a1': {
                    sb.setLength(0);
                    offset = JavaScriptCompressor.printSourceString(source, offset, sb);
                    tokens.add(new JavaScriptToken(tt, sb.toString()));
                    continue block4;
                }
                case '(': {
                    sb.setLength(0);
                    offset = JavaScriptCompressor.printSourceNumber(source, offset, sb);
                    tokens.add(new JavaScriptToken(tt, sb.toString()));
                    continue block4;
                }
            }
            String literal = (String)literals.get(new Integer(tt));
            if (literal == null) continue;
            tokens.add(new JavaScriptToken(tt, literal));
        }
        return tokens;
    }

    private static void processStringLiterals(ArrayList tokens, boolean merge) {
        JavaScriptToken token;
        int i;
        int length = tokens.size();
        if (merge) {
            block3: for (i = 0; i < length; ++i) {
                token = (JavaScriptToken)tokens.get(i);
                switch (token.getType()) {
                    case 21: {
                        if (i <= 0 || i >= length) continue block3;
                        JavaScriptToken prevToken = (JavaScriptToken)tokens.get(i - 1);
                        JavaScriptToken nextToken = (JavaScriptToken)tokens.get(i + 1);
                        if (prevToken.getType() != 41 || nextToken.getType() != 41 || i != length - 1 && ((JavaScriptToken)tokens.get(i + 2)).getType() == 107) continue block3;
                        tokens.set(i - 1, new JavaScriptToken(41, prevToken.getValue() + nextToken.getValue()));
                        tokens.remove(i + 1);
                        tokens.remove(i);
                        --i;
                        length -= 2;
                    }
                }
            }
        }
        for (i = 0; i < length; ++i) {
            token = (JavaScriptToken)tokens.get(i);
            if (token.getType() != 41) continue;
            String tv = token.getValue();
            int singleQuoteCount = JavaScriptCompressor.countChar(tv, '\'');
            int doubleQuoteCount = JavaScriptCompressor.countChar(tv, '\"');
            char quotechar = doubleQuoteCount <= singleQuoteCount ? (char)'\"' : '\'';
            if ((tv = quotechar + JavaScriptCompressor.escapeString(tv, quotechar) + quotechar).indexOf("</script") >= 0) {
                tv = tv.replaceAll("<\\/script", "<\\\\/script");
            }
            tokens.set(i, new JavaScriptToken(41, tv));
        }
    }

    private static String escapeString(String s, char quotechar) {
        assert (quotechar == '\"' || quotechar == '\'');
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int L = s.length();
        for (int i = 0; i < L; ++i) {
            char c = s.charAt(i);
            if (c == quotechar) {
                sb.append("\\");
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean isValidIdentifier(String s) {
        Matcher m = SIMPLE_IDENTIFIER_NAME_PATTERN.matcher(s);
        return m.matches() && !reserved.contains(s);
    }

    private static void optimizeObjectMemberAccess(ArrayList tokens) {
        int length = tokens.size();
        for (int i = 0; i < length; ++i) {
            if (((JavaScriptToken)tokens.get(i)).getType() != 82 || i <= 0 || i >= length - 2 || ((JavaScriptToken)tokens.get(i - 1)).getType() != 39 || ((JavaScriptToken)tokens.get(i + 1)).getType() != 41 || ((JavaScriptToken)tokens.get(i + 2)).getType() != 83) continue;
            JavaScriptToken token = (JavaScriptToken)tokens.get(i + 1);
            String tv = token.getValue();
            if (!JavaScriptCompressor.isValidIdentifier(tv = tv.substring(1, tv.length() - 1))) continue;
            tokens.set(i, new JavaScriptToken(107, "."));
            tokens.set(i + 1, new JavaScriptToken(39, tv));
            tokens.remove(i + 2);
            i += 2;
            --length;
        }
    }

    private static void optimizeObjLitMemberDecl(ArrayList tokens) {
        int length = tokens.size();
        for (int i = 0; i < length; ++i) {
            if (((JavaScriptToken)tokens.get(i)).getType() != 66 || i <= 0 || ((JavaScriptToken)tokens.get(i - 1)).getType() != 41) continue;
            JavaScriptToken token = (JavaScriptToken)tokens.get(i - 1);
            String tv = token.getValue();
            if (!JavaScriptCompressor.isValidIdentifier(tv = tv.substring(1, tv.length() - 1))) continue;
            tokens.set(i - 1, new JavaScriptToken(39, tv));
        }
    }

    public JavaScriptCompressor(Reader in, ErrorReporter reporter) throws IOException, EvaluatorException {
        this.logger = reporter;
        this.tokens = JavaScriptCompressor.parse(in, reporter);
    }

    public void compress(Writer out, int linebreak, boolean munge, boolean verbose, boolean preserveAllSemiColons, boolean disableOptimizations) throws IOException {
        this.munge = munge;
        this.verbose = verbose;
        JavaScriptCompressor.processStringLiterals(this.tokens, !disableOptimizations);
        if (!disableOptimizations) {
            JavaScriptCompressor.optimizeObjectMemberAccess(this.tokens);
            JavaScriptCompressor.optimizeObjLitMemberDecl(this.tokens);
        }
        this.buildSymbolTree();
        this.mungeSymboltree();
        StringBuffer sb = this.printSymbolTree(linebreak, preserveAllSemiColons);
        out.write(sb.toString());
    }

    private ScriptOrFnScope getCurrentScope() {
        return (ScriptOrFnScope)this.scopes.peek();
    }

    private void enterScope(ScriptOrFnScope scope) {
        this.scopes.push(scope);
    }

    private void leaveCurrentScope() {
        this.scopes.pop();
    }

    private JavaScriptToken consumeToken() {
        return (JavaScriptToken)this.tokens.get(this.offset++);
    }

    private JavaScriptToken getToken(int delta) {
        return (JavaScriptToken)this.tokens.get(this.offset + delta);
    }

    private JavaScriptIdentifier getIdentifier(String symbol, ScriptOrFnScope scope) {
        while (scope != null) {
            JavaScriptIdentifier identifier = scope.getIdentifier(symbol);
            if (identifier != null) {
                return identifier;
            }
            scope = scope.getParentScope();
        }
        return null;
    }

    private void protectScopeFromObfuscation(ScriptOrFnScope scope) {
        assert (scope != null);
        if (scope == this.globalScope) {
            return;
        }
        while (scope.getParentScope() != this.globalScope) {
            scope = scope.getParentScope();
        }
        assert (scope.getParentScope() == this.globalScope);
        scope.preventMunging();
    }

    private String getDebugString(int max) {
        assert (max > 0);
        StringBuffer result = new StringBuffer();
        int start = Math.max(this.offset - max, 0);
        int end = Math.min(this.offset + max, this.tokens.size());
        for (int i = start; i < end; ++i) {
            JavaScriptToken token = (JavaScriptToken)this.tokens.get(i);
            if (i == this.offset - 1) {
                result.append(" ---> ");
            }
            result.append(token.getValue());
            if (i != this.offset - 1) continue;
            result.append(" <--- ");
        }
        return result.toString();
    }

    private void warn(String message, boolean showDebugString) {
        if (this.verbose) {
            if (showDebugString) {
                message = message + "\n" + this.getDebugString(10);
            }
            this.logger.warning(message, null, -1, null, -1);
        }
    }

    private void parseFunctionDeclaration() {
        JavaScriptIdentifier identifier;
        ScriptOrFnScope fnScope;
        String symbol;
        ScriptOrFnScope currentScope = this.getCurrentScope();
        JavaScriptToken token = this.consumeToken();
        if (token.getType() == 39) {
            if (this.mode == 1) {
                symbol = token.getValue();
                if (currentScope.getIdentifier(symbol) != null) {
                    this.warn("The function " + symbol + " has already been declared in the same scope...", true);
                }
                currentScope.declareIdentifier(symbol);
            }
            token = this.consumeToken();
        }
        assert (token.getType() == 86);
        if (this.mode == 1) {
            fnScope = new ScriptOrFnScope(this.braceNesting, currentScope);
            this.indexedScopes.put(new Integer(this.offset), fnScope);
        } else {
            fnScope = (ScriptOrFnScope)this.indexedScopes.get(new Integer(this.offset));
        }
        int argpos = 0;
        while ((token = this.consumeToken()).getType() != 87) {
            assert (token.getType() == 39 || token.getType() == 88);
            if (token.getType() != 39 || this.mode != 1) continue;
            symbol = token.getValue();
            identifier = fnScope.declareIdentifier(symbol);
            if (symbol.equals("$super") && argpos == 0) {
                identifier.preventMunging();
            }
            ++argpos;
        }
        token = this.consumeToken();
        assert (token.getType() == 84);
        ++this.braceNesting;
        token = this.getToken(0);
        if (token.getType() == 41 && this.getToken(1).getType() == 81) {
            this.consumeToken();
            String hints = token.getValue();
            hints = hints.substring(1, hints.length() - 1).trim();
            StringTokenizer st1 = new StringTokenizer(hints, ",");
            while (st1.hasMoreTokens()) {
                String hint = st1.nextToken();
                int idx = hint.indexOf(58);
                if (idx <= 0 || idx >= hint.length() - 1) {
                    if (this.mode != 1) break;
                    this.warn("Invalid hint syntax: " + hint, true);
                    break;
                }
                String variableName = hint.substring(0, idx).trim();
                String variableType = hint.substring(idx + 1).trim();
                if (this.mode == 1) {
                    fnScope.addHint(variableName, variableType);
                    continue;
                }
                if (this.mode != 2) continue;
                identifier = fnScope.getIdentifier(variableName);
                if (identifier != null) {
                    if (variableType.equals("nomunge")) {
                        identifier.preventMunging();
                        continue;
                    }
                    this.warn("Unsupported hint value: " + hint, true);
                    continue;
                }
                this.warn("Hint refers to an unknown identifier: " + hint, true);
            }
        }
        this.parseScope(fnScope);
    }

    private void parseCatch() {
        JavaScriptToken token = this.getToken(-1);
        assert (token.getType() == 123);
        token = this.consumeToken();
        assert (token.getType() == 86);
        token = this.consumeToken();
        assert (token.getType() == 39);
        String symbol = token.getValue();
        ScriptOrFnScope currentScope = this.getCurrentScope();
        if (this.mode == 1) {
            currentScope.declareIdentifier(symbol);
        } else {
            JavaScriptIdentifier identifier = this.getIdentifier(symbol, currentScope);
            identifier.incrementRefcount();
        }
        token = this.consumeToken();
        assert (token.getType() == 87);
    }

    private void parseExpression() {
        int expressionBraceNesting = this.braceNesting;
        int bracketNesting = 0;
        int parensNesting = 0;
        int length = this.tokens.size();
        while (this.offset < length) {
            JavaScriptToken token = this.consumeToken();
            ScriptOrFnScope currentScope = this.getCurrentScope();
            switch (token.getType()) {
                case 81: 
                case 88: {
                    if (this.braceNesting != expressionBraceNesting || bracketNesting != 0 || parensNesting != 0) break;
                    return;
                }
                case 108: {
                    this.parseFunctionDeclaration();
                    break;
                }
                case 84: {
                    ++this.braceNesting;
                    break;
                }
                case 85: {
                    --this.braceNesting;
                    assert (this.braceNesting >= expressionBraceNesting);
                    break;
                }
                case 82: {
                    ++bracketNesting;
                    break;
                }
                case 83: {
                    --bracketNesting;
                    break;
                }
                case 86: {
                    ++parensNesting;
                    break;
                }
                case 87: {
                    --parensNesting;
                    break;
                }
                case 160: {
                    if (this.mode != 1) break;
                    this.protectScopeFromObfuscation(currentScope);
                    this.warn("Using JScript conditional comments is not recommended." + (this.munge ? " Moreover, using JScript conditional comments reduces the level of compression!" : ""), true);
                    break;
                }
                case 39: {
                    String symbol = token.getValue();
                    if (this.mode == 1) {
                        if (!symbol.equals("eval")) break;
                        this.protectScopeFromObfuscation(currentScope);
                        this.warn("Using 'eval' is not recommended." + (this.munge ? " Moreover, using 'eval' reduces the level of compression!" : ""), true);
                        break;
                    }
                    if (this.mode != 2 || this.offset >= 2 && (this.getToken(-2).getType() == 107 || this.getToken(-2).getType() == 150 || this.getToken(-2).getType() == 151) || this.getToken(0).getType() == 66) break;
                    JavaScriptIdentifier identifier = this.getIdentifier(symbol, currentScope);
                    if (identifier == null) {
                        if (symbol.length() > 3 || builtin.contains(symbol)) break;
                        this.globalScope.declareIdentifier(symbol);
                        break;
                    }
                    identifier.incrementRefcount();
                }
            }
        }
    }

    private void parseScope(ScriptOrFnScope scope) {
        int length = this.tokens.size();
        this.enterScope(scope);
        while (this.offset < length) {
            JavaScriptToken token = this.consumeToken();
            block0 : switch (token.getType()) {
                case 121: {
                    if (this.mode == 1 && scope.incrementVarCount() > 1) {
                        this.warn("Try to use a single 'var' statement per scope.", true);
                    }
                }
                case 153: {
                    String symbol;
                    do {
                        token = this.consumeToken();
                        assert (token.getType() == 39);
                        if (this.mode == 1) {
                            symbol = token.getValue();
                            if (scope.getIdentifier(symbol) == null) {
                                scope.declareIdentifier(symbol);
                            } else {
                                this.warn("The variable " + symbol + " has already been declared in the same scope...", true);
                            }
                        }
                        token = this.getToken(0);
                        assert (token.getType() == 81 || token.getType() == 89 || token.getType() == 88 || token.getType() == 52);
                        if (token.getType() == 52) break block0;
                        this.parseExpression();
                    } while ((token = this.getToken(-1)).getType() != 81);
                    break;
                }
                case 108: {
                    this.parseFunctionDeclaration();
                    break;
                }
                case 84: {
                    ++this.braceNesting;
                    break;
                }
                case 85: {
                    --this.braceNesting;
                    assert (this.braceNesting >= scope.getBraceNesting());
                    if (this.braceNesting != scope.getBraceNesting()) break;
                    this.leaveCurrentScope();
                    return;
                }
                case 122: {
                    if (this.mode != 1) break;
                    this.protectScopeFromObfuscation(scope);
                    this.warn("Using 'with' is not recommended." + (this.munge ? " Moreover, using 'with' reduces the level of compression!" : ""), true);
                    break;
                }
                case 123: {
                    this.parseCatch();
                    break;
                }
                case 160: {
                    if (this.mode != 1) break;
                    this.protectScopeFromObfuscation(scope);
                    this.warn("Using JScript conditional comments is not recommended." + (this.munge ? " Moreover, using JScript conditional comments reduces the level of compression." : ""), true);
                    break;
                }
                case 39: {
                    String symbol = token.getValue();
                    if (this.mode == 1) {
                        if (!symbol.equals("eval")) break;
                        this.protectScopeFromObfuscation(scope);
                        this.warn("Using 'eval' is not recommended." + (this.munge ? " Moreover, using 'eval' reduces the level of compression!" : ""), true);
                        break;
                    }
                    if (this.mode != 2 || this.offset >= 2 && this.getToken(-2).getType() == 107 || this.getToken(0).getType() == 66) break;
                    JavaScriptIdentifier identifier = this.getIdentifier(symbol, scope);
                    if (identifier == null) {
                        if (symbol.length() > 3 || builtin.contains(symbol)) break;
                        this.globalScope.declareIdentifier(symbol);
                        break;
                    }
                    identifier.incrementRefcount();
                }
            }
        }
    }

    private void buildSymbolTree() {
        this.offset = 0;
        this.braceNesting = 0;
        this.scopes.clear();
        this.indexedScopes.clear();
        this.indexedScopes.put(new Integer(0), this.globalScope);
        this.mode = 1;
        this.parseScope(this.globalScope);
    }

    private void mungeSymboltree() {
        if (!this.munge) {
            return;
        }
        this.offset = 0;
        this.braceNesting = 0;
        this.scopes.clear();
        this.mode = 2;
        this.parseScope(this.globalScope);
        this.globalScope.munge();
    }

    private StringBuffer printSymbolTree(int linebreakpos, boolean preserveAllSemiColons) throws IOException {
        this.offset = 0;
        this.braceNesting = 0;
        this.scopes.clear();
        JavaScriptToken lastToken = this.getToken(0);
        int length = this.tokens.size();
        StringBuffer result = new StringBuffer();
        int linestartpos = 0;
        this.enterScope(this.globalScope);
        block14: while (this.offset < length) {
            JavaScriptToken token = this.consumeToken();
            String symbol = token.getValue();
            ScriptOrFnScope currentScope = this.getCurrentScope();
            switch (token.getType()) {
                case 150: 
                case 151: {
                    lastToken = token;
                }
                case 39: {
                    if (this.offset >= 2 && this.getToken(-2).getType() == 107 || this.getToken(0).getType() == 66) {
                        result.append(symbol);
                        continue block14;
                    }
                    JavaScriptIdentifier identifier = this.getIdentifier(symbol, currentScope);
                    if (identifier != null) {
                        if (identifier.getMungedValue() != null) {
                            result.append(identifier.getMungedValue());
                        } else {
                            result.append(symbol);
                        }
                        if (currentScope == this.globalScope || identifier.getRefcount() != 0) continue block14;
                        this.warn("The symbol " + symbol + " is declared but is apparently never used.\nThis code can probably be written in a more compact way.", true);
                        continue block14;
                    }
                    result.append(symbol);
                    continue block14;
                }
                case 40: 
                case 41: 
                case 48: {
                    result.append(symbol);
                    continue block14;
                }
                case 21: 
                case 22: {
                    result.append((String)literals.get(new Integer(token.getType())));
                    if (this.offset >= length) continue block14;
                    token = this.getToken(0);
                    if (token.getType() == 105 || token.getType() == 106 || token.getType() == 21 || token.getType() == 106) {
                        result.append(' ');
                        continue block14;
                    }
                    if ((token.getType() != 28 || this.getToken(-1).getType() != 21) && (token.getType() != 29 || this.getToken(-1).getType() != 22)) continue block14;
                    result.append(' ');
                    continue block14;
                }
                case 108: {
                    JavaScriptIdentifier identifier;
                    if (lastToken.getType() != 150 && lastToken.getType() != 151) {
                        result.append("function");
                    }
                    if ((token = this.consumeToken()).getType() == 39) {
                        result.append(' ');
                        symbol = token.getValue();
                        identifier = this.getIdentifier(symbol, currentScope);
                        assert (identifier != null);
                        if (identifier.getMungedValue() != null) {
                            result.append(identifier.getMungedValue());
                        } else {
                            result.append(symbol);
                        }
                        if (currentScope != this.globalScope && identifier.getRefcount() == 0) {
                            this.warn("The symbol " + symbol + " is declared but is apparently never used.\nThis code can probably be written in a more compact way.", true);
                        }
                        token = this.consumeToken();
                    }
                    assert (token.getType() == 86);
                    result.append('(');
                    currentScope = (ScriptOrFnScope)this.indexedScopes.get(new Integer(this.offset));
                    this.enterScope(currentScope);
                    while ((token = this.consumeToken()).getType() != 87) {
                        assert (token.getType() == 39 || token.getType() == 88);
                        if (token.getType() == 39) {
                            symbol = token.getValue();
                            identifier = this.getIdentifier(symbol, currentScope);
                            assert (identifier != null);
                            if (identifier.getMungedValue() != null) {
                                result.append(identifier.getMungedValue());
                                continue;
                            }
                            result.append(symbol);
                            continue;
                        }
                        if (token.getType() != 88) continue;
                        result.append(',');
                    }
                    result.append(')');
                    token = this.consumeToken();
                    assert (token.getType() == 84);
                    result.append('{');
                    ++this.braceNesting;
                    token = this.getToken(0);
                    if (token.getType() != 41 || this.getToken(1).getType() != 81) continue block14;
                    this.consumeToken();
                    this.consumeToken();
                    continue block14;
                }
                case 4: 
                case 32: {
                    result.append(literals.get(new Integer(token.getType())));
                    if (this.offset >= length || (token = this.getToken(0)).getType() == 86 || token.getType() == 82 || token.getType() == 84 || token.getType() == 41 || token.getType() == 48 || token.getType() == 81) continue block14;
                    result.append(' ');
                    continue block14;
                }
                case 50: 
                case 114: {
                    result.append(literals.get(new Integer(token.getType())));
                    if (this.offset >= length || this.getToken(0).getType() == 41) continue block14;
                    result.append(' ');
                    continue block14;
                }
                case 119: 
                case 120: {
                    result.append(literals.get(new Integer(token.getType())));
                    if (this.offset >= length || this.getToken(0).getType() == 81) continue block14;
                    result.append(' ');
                    continue block14;
                }
                case 84: {
                    result.append('{');
                    ++this.braceNesting;
                    continue block14;
                }
                case 85: {
                    result.append('}');
                    --this.braceNesting;
                    assert (this.braceNesting >= currentScope.getBraceNesting());
                    if (this.braceNesting != currentScope.getBraceNesting()) continue block14;
                    this.leaveCurrentScope();
                    continue block14;
                }
                case 81: {
                    if (preserveAllSemiColons || this.offset < length && this.getToken(0).getType() != 85) {
                        result.append(';');
                    }
                    if (linebreakpos < 0 || result.length() - linestartpos <= linebreakpos) continue block14;
                    result.append('\n');
                    linestartpos = result.length();
                    continue block14;
                }
                case 160: 
                case 161: {
                    if (result.length() > 0 && result.charAt(result.length() - 1) != '\n') {
                        result.append("\n");
                    }
                    result.append("/*");
                    result.append(symbol);
                    result.append("*/\n");
                    continue block14;
                }
            }
            String literal = (String)literals.get(new Integer(token.getType()));
            if (literal != null) {
                result.append(literal);
                continue;
            }
            this.warn("This symbol cannot be printed: " + symbol, true);
        }
        if (!preserveAllSemiColons && result.length() > 0 && this.getToken(-1).getType() != 160 && this.getToken(-1).getType() != 161) {
            if (result.charAt(result.length() - 1) == '\n') {
                result.setCharAt(result.length() - 1, ';');
            } else {
                result.append(';');
            }
        }
        return result;
    }

    static {
        char c;
        int i;
        char c2;
        builtin = new HashSet();
        literals = new Hashtable();
        reserved = new HashSet();
        builtin.add("NaN");
        builtin.add("top");
        ones = new ArrayList();
        for (c2 = 'a'; c2 <= 'z'; c2 = (char)(c2 + '\u0001')) {
            ones.add(Character.toString(c2));
        }
        for (c2 = 'A'; c2 <= 'Z'; c2 = (char)(c2 + '\u0001')) {
            ones.add(Character.toString(c2));
        }
        twos = new ArrayList();
        for (i = 0; i < ones.size(); ++i) {
            String one = (String)ones.get(i);
            for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                twos.add(one + Character.toString(c));
            }
            for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                twos.add(one + Character.toString(c));
            }
            for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                twos.add(one + Character.toString(c));
            }
        }
        twos.remove("as");
        twos.remove("is");
        twos.remove("do");
        twos.remove("if");
        twos.remove("in");
        twos.removeAll(builtin);
        threes = new ArrayList();
        for (i = 0; i < twos.size(); ++i) {
            String two = (String)twos.get(i);
            for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                threes.add(two + Character.toString(c));
            }
            for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                threes.add(two + Character.toString(c));
            }
            for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                threes.add(two + Character.toString(c));
            }
        }
        threes.remove("for");
        threes.remove("int");
        threes.remove("new");
        threes.remove("try");
        threes.remove("use");
        threes.remove("var");
        threes.removeAll(builtin);
        literals.put(new Integer(150), "get ");
        literals.put(new Integer(151), "set ");
        literals.put(new Integer(45), "true");
        literals.put(new Integer(44), "false");
        literals.put(new Integer(42), "null");
        literals.put(new Integer(43), "this");
        literals.put(new Integer(108), "function");
        literals.put(new Integer(88), ",");
        literals.put(new Integer(84), "{");
        literals.put(new Integer(85), "}");
        literals.put(new Integer(86), "(");
        literals.put(new Integer(87), ")");
        literals.put(new Integer(82), "[");
        literals.put(new Integer(83), "]");
        literals.put(new Integer(107), ".");
        literals.put(new Integer(30), "new ");
        literals.put(new Integer(31), "delete ");
        literals.put(new Integer(111), "if");
        literals.put(new Integer(112), "else");
        literals.put(new Integer(118), "for");
        literals.put(new Integer(52), " in ");
        literals.put(new Integer(122), "with");
        literals.put(new Integer(116), "while");
        literals.put(new Integer(117), "do");
        literals.put(new Integer(80), "try");
        literals.put(new Integer(123), "catch");
        literals.put(new Integer(124), "finally");
        literals.put(new Integer(50), "throw");
        literals.put(new Integer(113), "switch");
        literals.put(new Integer(119), "break");
        literals.put(new Integer(120), "continue");
        literals.put(new Integer(114), "case");
        literals.put(new Integer(115), "default");
        literals.put(new Integer(4), "return");
        literals.put(new Integer(121), "var ");
        literals.put(new Integer(81), ";");
        literals.put(new Integer(89), "=");
        literals.put(new Integer(96), "+=");
        literals.put(new Integer(97), "-=");
        literals.put(new Integer(98), "*=");
        literals.put(new Integer(99), "/=");
        literals.put(new Integer(100), "%=");
        literals.put(new Integer(90), "|=");
        literals.put(new Integer(91), "^=");
        literals.put(new Integer(92), "&=");
        literals.put(new Integer(93), "<<=");
        literals.put(new Integer(94), ">>=");
        literals.put(new Integer(95), ">>>=");
        literals.put(new Integer(101), "?");
        literals.put(new Integer(66), ":");
        literals.put(new Integer(102), ":");
        literals.put(new Integer(103), "||");
        literals.put(new Integer(104), "&&");
        literals.put(new Integer(9), "|");
        literals.put(new Integer(10), "^");
        literals.put(new Integer(11), "&");
        literals.put(new Integer(46), "===");
        literals.put(new Integer(47), "!==");
        literals.put(new Integer(12), "==");
        literals.put(new Integer(13), "!=");
        literals.put(new Integer(15), "<=");
        literals.put(new Integer(14), "<");
        literals.put(new Integer(17), ">=");
        literals.put(new Integer(16), ">");
        literals.put(new Integer(53), " instanceof ");
        literals.put(new Integer(18), "<<");
        literals.put(new Integer(19), ">>");
        literals.put(new Integer(20), ">>>");
        literals.put(new Integer(32), "typeof");
        literals.put(new Integer(125), "void ");
        literals.put(new Integer(153), "const ");
        literals.put(new Integer(26), "!");
        literals.put(new Integer(27), "~");
        literals.put(new Integer(28), "+");
        literals.put(new Integer(29), "-");
        literals.put(new Integer(105), "++");
        literals.put(new Integer(106), "--");
        literals.put(new Integer(21), "+");
        literals.put(new Integer(22), "-");
        literals.put(new Integer(23), "*");
        literals.put(new Integer(24), "/");
        literals.put(new Integer(25), "%");
        literals.put(new Integer(143), "::");
        literals.put(new Integer(142), "..");
        literals.put(new Integer(145), ".(");
        literals.put(new Integer(146), "@");
        literals.put(new Integer(152), "let ");
        literals.put(new Integer(72), "yield ");
        reserved.add("break");
        reserved.add("case");
        reserved.add("catch");
        reserved.add("continue");
        reserved.add("default");
        reserved.add("delete");
        reserved.add("do");
        reserved.add("else");
        reserved.add("finally");
        reserved.add("for");
        reserved.add("function");
        reserved.add("if");
        reserved.add("in");
        reserved.add("instanceof");
        reserved.add("new");
        reserved.add("return");
        reserved.add("switch");
        reserved.add("this");
        reserved.add("throw");
        reserved.add("try");
        reserved.add("typeof");
        reserved.add("var");
        reserved.add("void");
        reserved.add("while");
        reserved.add("with");
        reserved.add("abstract");
        reserved.add("boolean");
        reserved.add("byte");
        reserved.add("char");
        reserved.add("class");
        reserved.add("const");
        reserved.add("debugger");
        reserved.add("double");
        reserved.add("enum");
        reserved.add("export");
        reserved.add("extends");
        reserved.add("final");
        reserved.add("float");
        reserved.add("goto");
        reserved.add("implements");
        reserved.add("import");
        reserved.add("int");
        reserved.add("interface");
        reserved.add("long");
        reserved.add("native");
        reserved.add("package");
        reserved.add("private");
        reserved.add("protected");
        reserved.add("public");
        reserved.add("short");
        reserved.add("static");
        reserved.add("super");
        reserved.add("synchronized");
        reserved.add("throws");
        reserved.add("transient");
        reserved.add("volatile");
        reserved.add("arguments");
        reserved.add("eval");
        reserved.add("true");
        reserved.add("false");
        reserved.add("Infinity");
        reserved.add("NaN");
        reserved.add("null");
        reserved.add("undefined");
        SIMPLE_IDENTIFIER_NAME_PATTERN = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");
    }
}

